#define vec2 float2
#define vec4 float4
#define rgb xyz
#define rgba xyzw

typedef struct
{
	int width[8];
	int height[8];
	float cur_time;
	float total_time;
	float origROI[4];
	float resultROI[4];
	float angle;
}FilterParam;

const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_NEAREST;

static int get_global_id0(__global FilterParam* param)
{
	return get_global_id(0) - param->origROI[0]* param->width[0];
}

static int get_global_id1(__global FilterParam* param)
{
	return get_global_id(1) - param->origROI[1]* param->height[0];
}

vec4 INPUTSRC(image2d_t src_data, __global FilterParam* param, vec2 tc)
{
	tc = (vec2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
	return read_imagef(src_data, sampler, tc);
}

vec4 INPUT(image2d_t ovelay1,  __global FilterParam* param, vec2 tc)
{
	return read_imagef(ovelay1, sampler, (vec2)(tc.x,tc.y) );
}

	
	// Filter FocusColor
#define rgb2Gray_table(Y,R,G,B) {	\
(Y) = ((R + G + B + 512) >> 10);	\
}

__kernel void filter_FocusColor(__read_only image2d_t src,   		// input buffer image
								__read_only image2d_t merge,   		// image input merge
								__global int* tableR,   			// input buffer tableR
								__global int* tableG,   			// input buffer tableG
								__global int* tableB,   			// input buffer tableB
								__write_only image2d_t retImage,  	// output ruffer result
							    __private int left,
							    __private int right,
							    __private int top,
							    __private int buttom,
							    __private int cx,
							    __private int cy,
							    __private int offBytes,
						        __private int alpha,					// blend factor, scrope[0-100]	
								__global FilterParam* param)
{
	int w = get_global_id(0);
	int h = get_global_id(1);
	int width = get_image_width(src);
	int height = get_image_height(src);
	int W = get_global_size(0);
	int H = get_global_size(1);
	
	if(w >= width || h >= height)
			return;
	float2 resolution = (float2)(W,H);
	vec2 fragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
	vec2 uv = ((vec2)(fragCoord.x, fragCoord.y) + (vec2)(0.5f))/resolution.xy;
	float factor = (float)(alpha)/100.0f;
	
	float4 color = INPUTSRC(src, param, uv);
	uchar sr = color.x * 255;
	uchar sg = color.y * 255;
	uchar sb = color.z * 255;
	uchar ret_b, ret_g, ret_r;
	
	if((w >= left) && (w <= right) && (h >= top) && (h <= buttom))
	{
		int aXind, aYind, offNum, gray, iOlaGray;
		aXind = W/2 + w - cx;
		aYind = H/2 + cy - h;
		float2 uv2 = (float2)(aXind,aYind)/resolution.xy;
		float4 mergeColor = INPUT(merge, param, uv2);
		
		uchar iC = mergeColor.z * 255;
		int iG = 256 - iC;
		 
		int tr = tableR[sr];
		int tg = tableG[sg];
		int tb = tableB[sb];

		rgb2Gray_table(gray, tr, tg, tb);
		iOlaGray = gray*iG;
		
		tb = (iC * sb + iOlaGray) >> 8;
		tg = (iC * sg + iOlaGray) >> 8;
		tr = (iC * sr + iOlaGray) >> 8;
		
		ret_b = (uchar)(tb * factor + (1.0f - factor) * sb);
		ret_g = (uchar)(tg * factor + (1.0f - factor) * sg);
		ret_r = (uchar)(tr * factor + (1.0f - factor) * sr);
	}
	else
	{
		int gray;
		int tb, tg, tr;
		tb = tableB[sb]; tg = tableG[sg]; tr = tableR[sr];
		rgb2Gray_table(gray, tr, tg, tb);
		
		ret_b = (uchar)(gray * factor + (1.0f - factor) * sb);
		ret_g = (uchar)(gray * factor + (1.0f - factor) * sg);
		ret_r = (uchar)(gray * factor + (1.0f - factor) * sr);
	}
	
	write_imagef(retImage, (int2)(w, h), (float4)(ret_r / 255.0f, ret_g / 255.0f, ret_b / 255.0f, color.w));
}